# D2MS Gateway Setup Guide

## Package Contents

| File | Description |
|------|-------------|
| `TunnelSetup.exe` | Setup wizard (run as Administrator) |
| `D2MS_Gateway.exe` | Windows Service for tunnel connection |
| `get_ports.exe` | Configuration fetcher |
| `tunnel_client.exe` | Console client (for manual/debug use) |
| `sql.udl` | Local database connection settings |

## Quick Start

1. **Run as Administrator**: Right-click `TunnelSetup.exe` → "Run as administrator"

2. **Follow the 6-step wizard**:
   - Step 1: Detect your location
   - Step 2: Select tunnel server (closest recommended)
   - Step 3: Register device and fetch configuration
   - Step 4: Update server configuration
   - Step 5: Test connection
   - Step 6: Install Windows Service

3. **Done!** The D2MS_Gateway service starts automatically on boot.

## Manual Setup

If the wizard doesn't work:

1. Configure `sql.udl` (double-click to open Data Link Properties)
2. Run `get_ports.exe` to generate `frpc.ini`
3. Run `tunnel_client.exe` to start the tunnel

## Service Management

```cmd
sc stop D2MS_Gateway      # Stop service
sc start D2MS_Gateway     # Start service
sc delete D2MS_Gateway    # Remove service
```

## Troubleshooting

| Problem | Solution |
|---------|----------|
| Connection failed | Check firewall (outbound port 7060) |
| No devices found | Verify sql.udl database connection |
| TLS handshake failed | Re-run get_ports.exe to refresh config |
| Port in use | Stop existing tunnel client or service |

## Requirements

- Windows 10/11 (64-bit)
- Administrator privileges (for service installation)
- Network access to tunnel servers

---
*D2MS Gateway v1.0*
